﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class ProductMeasurementBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static ProductMeasurement GetItem(Guid productMeasurementID, string keyword)
        {
            return ProductMeasurementDB.GetItem(productMeasurementID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<ProductMeasurement> GetList(Guid productMeasurementID, string keyword)
        {
            return ProductMeasurementDB.GetList(productMeasurementID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid productMeasurementID, string keyword)
        {
            return ProductMeasurementDB.GetDataTable(productMeasurementID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid productMeasurementID, string keyword)
        {
            return ProductMeasurementDB.GetDataSet(productMeasurementID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(ProductMeasurement myProductMeasurement)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                ProductMeasurementDB.Save(myProductMeasurement);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
